package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CopyDbClusterSnapshotRequest(sourceDBClusterSnapshotIdentifier: String, targetDBClusterSnapshotIdentifier: String, kmsKeyId: scala.Option[String] = None, preSignedUrl: scala.Option[String] = None, copyTags: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest = {
    import CopyDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest.builder().sourceDBClusterSnapshotIdentifier(sourceDBClusterSnapshotIdentifier: java.lang.String).targetDBClusterSnapshotIdentifier(targetDBClusterSnapshotIdentifier: java.lang.String).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(copyTags.map(value => value: java.lang.Boolean))(_.copyTags).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CopyDbClusterSnapshotRequest.ReadOnly = CopyDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(sourceDBClusterSnapshotIdentifierValue, targetDBClusterSnapshotIdentifierValue, kmsKeyIdValue.map(value => value), preSignedUrlValue.map(value => value), copyTagsValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def sourceDBClusterSnapshotIdentifierValue: String
    def targetDBClusterSnapshotIdentifierValue: String
    def kmsKeyIdValue: scala.Option[String]
    def preSignedUrlValue: scala.Option[String]
    def copyTagsValue: scala.Option[primitives.BooleanOptional]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def sourceDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBClusterSnapshotIdentifierValue)
    def targetDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterSnapshotIdentifierValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
    def copyTags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTags", copyTagsValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest) extends CopyDbClusterSnapshotRequest.ReadOnly {
    override def sourceDBClusterSnapshotIdentifierValue: String = impl.sourceDBClusterSnapshotIdentifier(): String
    override def targetDBClusterSnapshotIdentifierValue: String = impl.targetDBClusterSnapshotIdentifier(): String
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
    override def copyTagsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTags()).map(value => value: primitives.BooleanOptional)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
}