package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbClusterParameterGroupRequest(dbClusterParameterGroupName: String, dbParameterGroupFamily: String, description: String, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest = {
    import CreateDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).description(description: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateDbClusterParameterGroupRequest.ReadOnly = CreateDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object CreateDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbClusterParameterGroupRequest = CreateDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue, dbParameterGroupFamilyValue, descriptionValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def dbClusterParameterGroupNameValue: String
    def dbParameterGroupFamilyValue: String
    def descriptionValue: String
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
    def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
    def description: ZIO[Any, Nothing, String] = ZIO.succeed(descriptionValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest) extends CreateDbClusterParameterGroupRequest.ReadOnly {
    override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
    override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
    override def descriptionValue: String = impl.description(): String
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
}