package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbClusterRequest(availabilityZones: scala.Option[Iterable[String]] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, dbClusterIdentifier: String, dbClusterParameterGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, dbSubnetGroupName: scala.Option[String] = None, engine: String, engineVersion: scala.Option[String] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUsername: scala.Option[String] = None, masterUserPassword: scala.Option[String] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, tags: scala.Option[Iterable[Tag]] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None, kmsKeyId: scala.Option[String] = None, preSignedUrl: scala.Option[String] = None, enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, globalClusterIdentifier: scala.Option[primitives.GlobalClusterIdentifier] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest = {
    import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest.builder().optionallyWith(availabilityZones.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.availabilityZones).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).engine(engine: java.lang.String).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(enableCloudwatchLogsExports.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.enableCloudwatchLogsExports).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).build()
  }
  def asReadOnly: CreateDbClusterRequest.ReadOnly = CreateDbClusterRequest.wrap(buildAwsValue())
}
object CreateDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbClusterRequest = CreateDbClusterRequest(availabilityZonesValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbClusterIdentifierValue, dbClusterParameterGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), dbSubnetGroupNameValue.map(value => value), engineValue, engineVersionValue.map(value => value), portValue.map(value => value), masterUsernameValue.map(value => value), masterUserPasswordValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), preSignedUrlValue.map(value => value), enableCloudwatchLogsExportsValue.map(value => value), deletionProtectionValue.map(value => value), globalClusterIdentifierValue.map(value => value))
    def availabilityZonesValue: scala.Option[List[String]]
    def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
    def dbClusterIdentifierValue: String
    def dbClusterParameterGroupNameValue: scala.Option[String]
    def vpcSecurityGroupIdsValue: scala.Option[List[String]]
    def dbSubnetGroupNameValue: scala.Option[String]
    def engineValue: String
    def engineVersionValue: scala.Option[String]
    def portValue: scala.Option[primitives.IntegerOptional]
    def masterUsernameValue: scala.Option[String]
    def masterUserPasswordValue: scala.Option[String]
    def preferredBackupWindowValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
    def kmsKeyIdValue: scala.Option[String]
    def preSignedUrlValue: scala.Option[String]
    def enableCloudwatchLogsExportsValue: scala.Option[List[String]]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier]
    def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
    def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
    def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
    def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
    def enableCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCloudwatchLogsExports", enableCloudwatchLogsExportsValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
    def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.GlobalClusterIdentifier] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest) extends CreateDbClusterRequest.ReadOnly {
    override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
    override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override def engineValue: String = impl.engine(): String
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
    override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
    override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
    override def enableCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enableCloudwatchLogsExports()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
    override def globalClusterIdentifierValue: scala.Option[primitives.GlobalClusterIdentifier] = scala.Option(impl.globalClusterIdentifier()).map(value => value: primitives.GlobalClusterIdentifier)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest): ReadOnly = new Wrapper(impl)
}