package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse = {
    import CreateDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
  }
  def asReadOnly: CreateDbClusterResponse.ReadOnly = CreateDbClusterResponse.wrap(buildAwsValue())
}
object CreateDbClusterResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbClusterResponse = CreateDbClusterResponse(dbClusterValue.map(value => value.editable))
    def dbClusterValue: scala.Option[DBCluster.ReadOnly]
    def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse) extends CreateDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse): ReadOnly = new Wrapper(impl)
}