package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbClusterSnapshotRequest(dbClusterSnapshotIdentifier: String, dbClusterIdentifier: String, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest = {
    import CreateDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateDbClusterSnapshotRequest.ReadOnly = CreateDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbClusterSnapshotRequest = CreateDbClusterSnapshotRequest(dbClusterSnapshotIdentifierValue, dbClusterIdentifierValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def dbClusterSnapshotIdentifierValue: String
    def dbClusterIdentifierValue: String
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest) extends CreateDbClusterSnapshotRequest.ReadOnly {
    override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
}