package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbClusterSnapshotResponse(dbClusterSnapshot: scala.Option[DBClusterSnapshot] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse = {
    import CreateDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse.builder().optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(_.dbClusterSnapshot).build()
  }
  def asReadOnly: CreateDbClusterSnapshotResponse.ReadOnly = CreateDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbClusterSnapshotResponse = CreateDbClusterSnapshotResponse(dbClusterSnapshotValue.map(value => value.editable))
    def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly]
    def dbClusterSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse) extends CreateDbClusterSnapshotResponse.ReadOnly { override def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly] = scala.Option(impl.dbClusterSnapshot()).map(value => DBClusterSnapshot.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse): ReadOnly = new Wrapper(impl)
}