package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbInstanceRequest(dbInstanceIdentifier: String, dbInstanceClass: String, engine: String, availabilityZone: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, autoMinorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None, dbClusterIdentifier: String, promotionTier: scala.Option[primitives.IntegerOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest = {
    import CreateDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).dbInstanceClass(dbInstanceClass: java.lang.String).engine(engine: java.lang.String).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).build()
  }
  def asReadOnly: CreateDbInstanceRequest.ReadOnly = CreateDbInstanceRequest.wrap(buildAwsValue())
}
object CreateDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbInstanceRequest = CreateDbInstanceRequest(dbInstanceIdentifierValue, dbInstanceClassValue, engineValue, availabilityZoneValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), dbClusterIdentifierValue, promotionTierValue.map(value => value))
    def dbInstanceIdentifierValue: String
    def dbInstanceClassValue: String
    def engineValue: String
    def availabilityZoneValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def dbClusterIdentifierValue: String
    def promotionTierValue: scala.Option[primitives.IntegerOptional]
    def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
    def dbInstanceClass: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceClassValue)
    def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest) extends CreateDbInstanceRequest.ReadOnly {
    override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
    override def dbInstanceClassValue: String = impl.dbInstanceClass(): String
    override def engineValue: String = impl.engine(): String
    override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: primitives.BooleanOptional)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest): ReadOnly = new Wrapper(impl)
}