package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbInstanceResponse(dbInstance: scala.Option[DBInstance] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse = {
    import CreateDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
  }
  def asReadOnly: CreateDbInstanceResponse.ReadOnly = CreateDbInstanceResponse.wrap(buildAwsValue())
}
object CreateDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbInstanceResponse = CreateDbInstanceResponse(dbInstanceValue.map(value => value.editable))
    def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
    def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse) extends CreateDbInstanceResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse): ReadOnly = new Wrapper(impl)
}