package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbSubnetGroupRequest(dbSubnetGroupName: String, dbSubnetGroupDescription: String, subnetIds: Iterable[String], tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest = {
    import CreateDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).dbSubnetGroupDescription(dbSubnetGroupDescription: java.lang.String).subnetIds(subnetIds.map { item => 
      item: java.lang.String
    }.asJavaCollection).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateDbSubnetGroupRequest.ReadOnly = CreateDbSubnetGroupRequest.wrap(buildAwsValue())
}
object CreateDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbSubnetGroupRequest = CreateDbSubnetGroupRequest(dbSubnetGroupNameValue, dbSubnetGroupDescriptionValue, subnetIdsValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def dbSubnetGroupNameValue: String
    def dbSubnetGroupDescriptionValue: String
    def subnetIdsValue: List[String]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
    def dbSubnetGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupDescriptionValue)
    def subnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIdsValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest) extends CreateDbSubnetGroupRequest.ReadOnly {
    override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String
    override def dbSubnetGroupDescriptionValue: String = impl.dbSubnetGroupDescription(): String
    override def subnetIdsValue: List[String] = impl.subnetIds().asScala.map { item => 
      item: String
    }.toList
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
}