package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDbSubnetGroupResponse(dbSubnetGroup: scala.Option[DBSubnetGroup] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse = {
    import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse.builder().optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).build()
  }
  def asReadOnly: CreateDbSubnetGroupResponse.ReadOnly = CreateDbSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDbSubnetGroupResponse = CreateDbSubnetGroupResponse(dbSubnetGroupValue.map(value => value.editable))
    def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
    def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse) extends CreateDbSubnetGroupResponse.ReadOnly { override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse): ReadOnly = new Wrapper(impl)
}