package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateEventSubscriptionRequest(subscriptionName: String, snsTopicArn: String, sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, sourceIds: scala.Option[Iterable[String]] = None, enabled: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest = {
    import CreateEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).snsTopicArn(snsTopicArn: java.lang.String).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).optionallyWith(sourceIds.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.sourceIds).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateEventSubscriptionRequest.ReadOnly = CreateEventSubscriptionRequest.wrap(buildAwsValue())
}
object CreateEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(subscriptionNameValue, snsTopicArnValue, sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value), sourceIdsValue.map(value => value), enabledValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def subscriptionNameValue: String
    def snsTopicArnValue: String
    def sourceTypeValue: scala.Option[String]
    def eventCategoriesValue: scala.Option[List[String]]
    def sourceIdsValue: scala.Option[List[String]]
    def enabledValue: scala.Option[primitives.BooleanOptional]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
    def snsTopicArn: ZIO[Any, Nothing, String] = ZIO.succeed(snsTopicArnValue)
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
    def sourceIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIds", sourceIdsValue)
    def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest) extends CreateEventSubscriptionRequest.ReadOnly {
    override def subscriptionNameValue: String = impl.subscriptionName(): String
    override def snsTopicArnValue: String = impl.snsTopicArn(): String
    override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def sourceIdsValue: scala.Option[List[String]] = scala.Option(impl.sourceIds()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def enabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enabled()).map(value => value: primitives.BooleanOptional)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
}