package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGlobalClusterRequest(globalClusterIdentifier: primitives.GlobalClusterIdentifier, sourceDBClusterIdentifier: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, databaseName: scala.Option[String] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest = {
    import CreateGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).optionallyWith(sourceDBClusterIdentifier.map(value => value: java.lang.String))(_.sourceDBClusterIdentifier).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).build()
  }
  def asReadOnly: CreateGlobalClusterRequest.ReadOnly = CreateGlobalClusterRequest.wrap(buildAwsValue())
}
object CreateGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGlobalClusterRequest = CreateGlobalClusterRequest(globalClusterIdentifierValue, sourceDBClusterIdentifierValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), deletionProtectionValue.map(value => value), databaseNameValue.map(value => value), storageEncryptedValue.map(value => value))
    def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier
    def sourceDBClusterIdentifierValue: scala.Option[String]
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
    def databaseNameValue: scala.Option[String]
    def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
    def globalClusterIdentifier: ZIO[Any, Nothing, primitives.GlobalClusterIdentifier] = ZIO.succeed(globalClusterIdentifierValue)
    def sourceDBClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDBClusterIdentifier", sourceDBClusterIdentifierValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
    def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest) extends CreateGlobalClusterRequest.ReadOnly {
    override def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier = impl.globalClusterIdentifier(): primitives.GlobalClusterIdentifier
    override def sourceDBClusterIdentifierValue: scala.Option[String] = scala.Option(impl.sourceDBClusterIdentifier()).map(value => value: String)
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
    override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
    override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest): ReadOnly = new Wrapper(impl)
}