package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGlobalClusterResponse(globalCluster: scala.Option[GlobalCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse = {
    import CreateGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse.builder().optionallyWith(globalCluster.map(value => value.buildAwsValue()))(_.globalCluster).build()
  }
  def asReadOnly: CreateGlobalClusterResponse.ReadOnly = CreateGlobalClusterResponse.wrap(buildAwsValue())
}
object CreateGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGlobalClusterResponse = CreateGlobalClusterResponse(globalClusterValue.map(value => value.editable))
    def globalClusterValue: scala.Option[GlobalCluster.ReadOnly]
    def globalCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GlobalCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalCluster", globalClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse) extends CreateGlobalClusterResponse.ReadOnly { override def globalClusterValue: scala.Option[GlobalCluster.ReadOnly] = scala.Option(impl.globalCluster()).map(value => GlobalCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse): ReadOnly = new Wrapper(impl)
}