package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBCluster(availabilityZones: scala.Option[Iterable[String]] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterParameterGroup: scala.Option[String] = None, dbSubnetGroup: scala.Option[String] = None, status: scala.Option[String] = None, percentProgress: scala.Option[String] = None, earliestRestorableTime: scala.Option[primitives.TStamp] = None, endpoint: scala.Option[String] = None, readerEndpoint: scala.Option[String] = None, multiAZ: scala.Option[Boolean] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, latestRestorableTime: scala.Option[primitives.TStamp] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUsername: scala.Option[String] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, replicationSourceIdentifier: scala.Option[String] = None, readReplicaIdentifiers: scala.Option[Iterable[String]] = None, dbClusterMembers: scala.Option[Iterable[DBClusterMember]] = None, vpcSecurityGroups: scala.Option[Iterable[VpcSecurityGroupMembership]] = None, hostedZoneId: scala.Option[String] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbClusterResourceId: scala.Option[String] = None, dbClusterArn: scala.Option[String] = None, associatedRoles: scala.Option[Iterable[DBClusterRole]] = None, clusterCreateTime: scala.Option[primitives.TStamp] = None, enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None, deletionProtection: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBCluster = {
    import DBCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBCluster.builder().optionallyWith(availabilityZones.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.availabilityZones).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterParameterGroup.map(value => value: java.lang.String))(_.dbClusterParameterGroup).optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(_.dbSubnetGroup).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(percentProgress.map(value => value: java.lang.String))(_.percentProgress).optionallyWith(earliestRestorableTime.map(value => value: java.time.Instant))(_.earliestRestorableTime).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(readerEndpoint.map(value => value: java.lang.String))(_.readerEndpoint).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(latestRestorableTime.map(value => value: java.time.Instant))(_.latestRestorableTime).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(replicationSourceIdentifier.map(value => value: java.lang.String))(_.replicationSourceIdentifier).optionallyWith(readReplicaIdentifiers.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.readReplicaIdentifiers).optionallyWith(dbClusterMembers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbClusterMembers).optionallyWith(vpcSecurityGroups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.vpcSecurityGroups).optionallyWith(hostedZoneId.map(value => value: java.lang.String))(_.hostedZoneId).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbClusterResourceId.map(value => value: java.lang.String))(_.dbClusterResourceId).optionallyWith(dbClusterArn.map(value => value: java.lang.String))(_.dbClusterArn).optionallyWith(associatedRoles.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.associatedRoles).optionallyWith(clusterCreateTime.map(value => value: java.time.Instant))(_.clusterCreateTime).optionallyWith(enabledCloudwatchLogsExports.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.enabledCloudwatchLogsExports).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).build()
  }
  def asReadOnly: DBCluster.ReadOnly = DBCluster.wrap(buildAwsValue())
}
object DBCluster {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBCluster] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBCluster = DBCluster(availabilityZonesValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterParameterGroupValue.map(value => value), dbSubnetGroupValue.map(value => value), statusValue.map(value => value), percentProgressValue.map(value => value), earliestRestorableTimeValue.map(value => value), endpointValue.map(value => value), readerEndpointValue.map(value => value), multiAZValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), latestRestorableTimeValue.map(value => value), portValue.map(value => value), masterUsernameValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), replicationSourceIdentifierValue.map(value => value), readReplicaIdentifiersValue.map(value => value), dbClusterMembersValue.map(value => value.map { item => 
      item.editable
    }), vpcSecurityGroupsValue.map(value => value.map { item => 
      item.editable
    }), hostedZoneIdValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbClusterResourceIdValue.map(value => value), dbClusterArnValue.map(value => value), associatedRolesValue.map(value => value.map { item => 
      item.editable
    }), clusterCreateTimeValue.map(value => value), enabledCloudwatchLogsExportsValue.map(value => value), deletionProtectionValue.map(value => value))
    def availabilityZonesValue: scala.Option[List[String]]
    def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
    def dbClusterIdentifierValue: scala.Option[String]
    def dbClusterParameterGroupValue: scala.Option[String]
    def dbSubnetGroupValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def percentProgressValue: scala.Option[String]
    def earliestRestorableTimeValue: scala.Option[primitives.TStamp]
    def endpointValue: scala.Option[String]
    def readerEndpointValue: scala.Option[String]
    def multiAZValue: scala.Option[Boolean]
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def latestRestorableTimeValue: scala.Option[primitives.TStamp]
    def portValue: scala.Option[primitives.IntegerOptional]
    def masterUsernameValue: scala.Option[String]
    def preferredBackupWindowValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def replicationSourceIdentifierValue: scala.Option[String]
    def readReplicaIdentifiersValue: scala.Option[List[String]]
    def dbClusterMembersValue: scala.Option[List[DBClusterMember.ReadOnly]]
    def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]]
    def hostedZoneIdValue: scala.Option[String]
    def storageEncryptedValue: scala.Option[Boolean]
    def kmsKeyIdValue: scala.Option[String]
    def dbClusterResourceIdValue: scala.Option[String]
    def dbClusterArnValue: scala.Option[String]
    def associatedRolesValue: scala.Option[List[DBClusterRole.ReadOnly]]
    def clusterCreateTimeValue: scala.Option[primitives.TStamp]
    def enabledCloudwatchLogsExportsValue: scala.Option[List[String]]
    def deletionProtectionValue: scala.Option[Boolean]
    def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
    def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
    def dbClusterParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroupValue)
    def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
    def earliestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("earliestRestorableTime", earliestRestorableTimeValue)
    def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
    def readerEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readerEndpoint", readerEndpointValue)
    def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def latestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def replicationSourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicationSourceIdentifier", replicationSourceIdentifierValue)
    def readReplicaIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiersValue)
    def dbClusterMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterMember.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembersValue)
    def vpcSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VpcSecurityGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroupsValue)
    def hostedZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hostedZoneId", hostedZoneIdValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def dbClusterResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceIdValue)
    def dbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterArn", dbClusterArnValue)
    def associatedRoles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterRole.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedRoles", associatedRolesValue)
    def clusterCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTimeValue)
    def enabledCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabledCloudwatchLogsExports", enabledCloudwatchLogsExportsValue)
    def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBCluster) extends DBCluster.ReadOnly {
    override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
    override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override def dbClusterParameterGroupValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroup()).map(value => value: String)
    override def dbSubnetGroupValue: scala.Option[String] = scala.Option(impl.dbSubnetGroup()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def percentProgressValue: scala.Option[String] = scala.Option(impl.percentProgress()).map(value => value: String)
    override def earliestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.earliestRestorableTime()).map(value => value: primitives.TStamp)
    override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
    override def readerEndpointValue: scala.Option[String] = scala.Option(impl.readerEndpoint()).map(value => value: String)
    override def multiAZValue: scala.Option[Boolean] = scala.Option(impl.multiAZ()).map(value => value: Boolean)
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def latestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.latestRestorableTime()).map(value => value: primitives.TStamp)
    override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
    override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def replicationSourceIdentifierValue: scala.Option[String] = scala.Option(impl.replicationSourceIdentifier()).map(value => value: String)
    override def readReplicaIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.readReplicaIdentifiers()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def dbClusterMembersValue: scala.Option[List[DBClusterMember.ReadOnly]] = scala.Option(impl.dbClusterMembers()).map(value => value.asScala.map { item => 
      DBClusterMember.wrap(item)
    }.toList)
    override def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]] = scala.Option(impl.vpcSecurityGroups()).map(value => value.asScala.map { item => 
      VpcSecurityGroupMembership.wrap(item)
    }.toList)
    override def hostedZoneIdValue: scala.Option[String] = scala.Option(impl.hostedZoneId()).map(value => value: String)
    override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def dbClusterResourceIdValue: scala.Option[String] = scala.Option(impl.dbClusterResourceId()).map(value => value: String)
    override def dbClusterArnValue: scala.Option[String] = scala.Option(impl.dbClusterArn()).map(value => value: String)
    override def associatedRolesValue: scala.Option[List[DBClusterRole.ReadOnly]] = scala.Option(impl.associatedRoles()).map(value => value.asScala.map { item => 
      DBClusterRole.wrap(item)
    }.toList)
    override def clusterCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.clusterCreateTime()).map(value => value: primitives.TStamp)
    override def enabledCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enabledCloudwatchLogsExports()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def deletionProtectionValue: scala.Option[Boolean] = scala.Option(impl.deletionProtection()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBCluster): ReadOnly = new Wrapper(impl)
}