package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterMember(dbInstanceIdentifier: scala.Option[String] = None, isClusterWriter: scala.Option[Boolean] = None, dbClusterParameterGroupStatus: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterMember = {
    import DBClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterMember.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(_.isClusterWriter).optionallyWith(dbClusterParameterGroupStatus.map(value => value: java.lang.String))(_.dbClusterParameterGroupStatus).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).build()
  }
  def asReadOnly: DBClusterMember.ReadOnly = DBClusterMember.wrap(buildAwsValue())
}
object DBClusterMember {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterMember] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterMember = DBClusterMember(dbInstanceIdentifierValue.map(value => value), isClusterWriterValue.map(value => value), dbClusterParameterGroupStatusValue.map(value => value), promotionTierValue.map(value => value))
    def dbInstanceIdentifierValue: scala.Option[String]
    def isClusterWriterValue: scala.Option[Boolean]
    def dbClusterParameterGroupStatusValue: scala.Option[String]
    def promotionTierValue: scala.Option[primitives.IntegerOptional]
    def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
    def isClusterWriter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isClusterWriter", isClusterWriterValue)
    def dbClusterParameterGroupStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupStatus", dbClusterParameterGroupStatusValue)
    def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterMember) extends DBClusterMember.ReadOnly {
    override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override def isClusterWriterValue: scala.Option[Boolean] = scala.Option(impl.isClusterWriter()).map(value => value: Boolean)
    override def dbClusterParameterGroupStatusValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupStatus()).map(value => value: String)
    override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterMember): ReadOnly = new Wrapper(impl)
}