package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterParameterGroup(dbClusterParameterGroupName: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, description: scala.Option[String] = None, dbClusterParameterGroupArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup = {
    import DBClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(dbClusterParameterGroupArn.map(value => value: java.lang.String))(_.dbClusterParameterGroupArn).build()
  }
  def asReadOnly: DBClusterParameterGroup.ReadOnly = DBClusterParameterGroup.wrap(buildAwsValue())
}
object DBClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterParameterGroup = DBClusterParameterGroup(dbClusterParameterGroupNameValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), descriptionValue.map(value => value), dbClusterParameterGroupArnValue.map(value => value))
    def dbClusterParameterGroupNameValue: scala.Option[String]
    def dbParameterGroupFamilyValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def dbClusterParameterGroupArnValue: scala.Option[String]
    def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
    def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def dbClusterParameterGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupArn", dbClusterParameterGroupArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup) extends DBClusterParameterGroup.ReadOnly {
    override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
    override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def dbClusterParameterGroupArnValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup): ReadOnly = new Wrapper(impl)
}