package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterRole(roleArn: scala.Option[String] = None, status: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterRole = {
    import DBClusterRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterRole.builder().optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
  }
  def asReadOnly: DBClusterRole.ReadOnly = DBClusterRole.wrap(buildAwsValue())
}
object DBClusterRole {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterRole] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterRole = DBClusterRole(roleArnValue.map(value => value), statusValue.map(value => value))
    def roleArnValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def roleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArn", roleArnValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterRole) extends DBClusterRole.ReadOnly {
    override def roleArnValue: scala.Option[String] = scala.Option(impl.roleArn()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterRole): ReadOnly = new Wrapper(impl)
}