package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterSnapshot(availabilityZones: scala.Option[Iterable[String]] = None, dbClusterSnapshotIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, snapshotCreateTime: scala.Option[primitives.TStamp] = None, engine: scala.Option[String] = None, status: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, vpcId: scala.Option[String] = None, clusterCreateTime: scala.Option[primitives.TStamp] = None, masterUsername: scala.Option[String] = None, engineVersion: scala.Option[String] = None, snapshotType: scala.Option[String] = None, percentProgress: scala.Option[primitives.Integer] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbClusterSnapshotArn: scala.Option[String] = None, sourceDBClusterSnapshotArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterSnapshot = {
    import DBClusterSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshot.builder().optionallyWith(availabilityZones.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.availabilityZones).optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(snapshotCreateTime.map(value => value: java.time.Instant))(_.snapshotCreateTime).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(clusterCreateTime.map(value => value: java.time.Instant))(_.clusterCreateTime).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(percentProgress.map(value => value: java.lang.Integer))(_.percentProgress).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbClusterSnapshotArn.map(value => value: java.lang.String))(_.dbClusterSnapshotArn).optionallyWith(sourceDBClusterSnapshotArn.map(value => value: java.lang.String))(_.sourceDBClusterSnapshotArn).build()
  }
  def asReadOnly: DBClusterSnapshot.ReadOnly = DBClusterSnapshot.wrap(buildAwsValue())
}
object DBClusterSnapshot {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterSnapshot = DBClusterSnapshot(availabilityZonesValue.map(value => value), dbClusterSnapshotIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), snapshotCreateTimeValue.map(value => value), engineValue.map(value => value), statusValue.map(value => value), portValue.map(value => value), vpcIdValue.map(value => value), clusterCreateTimeValue.map(value => value), masterUsernameValue.map(value => value), engineVersionValue.map(value => value), snapshotTypeValue.map(value => value), percentProgressValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbClusterSnapshotArnValue.map(value => value), sourceDBClusterSnapshotArnValue.map(value => value))
    def availabilityZonesValue: scala.Option[List[String]]
    def dbClusterSnapshotIdentifierValue: scala.Option[String]
    def dbClusterIdentifierValue: scala.Option[String]
    def snapshotCreateTimeValue: scala.Option[primitives.TStamp]
    def engineValue: scala.Option[String]
    def statusValue: scala.Option[String]
    def portValue: scala.Option[primitives.Integer]
    def vpcIdValue: scala.Option[String]
    def clusterCreateTimeValue: scala.Option[primitives.TStamp]
    def masterUsernameValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def snapshotTypeValue: scala.Option[String]
    def percentProgressValue: scala.Option[primitives.Integer]
    def storageEncryptedValue: scala.Option[Boolean]
    def kmsKeyIdValue: scala.Option[String]
    def dbClusterSnapshotArnValue: scala.Option[String]
    def sourceDBClusterSnapshotArnValue: scala.Option[String]
    def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
    def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
    def snapshotCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTimeValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
    def clusterCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTimeValue)
    def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
    def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def dbClusterSnapshotArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotArn", dbClusterSnapshotArnValue)
    def sourceDBClusterSnapshotArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDBClusterSnapshotArn", sourceDBClusterSnapshotArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshot) extends DBClusterSnapshot.ReadOnly {
    override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
    override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override def snapshotCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.snapshotCreateTime()).map(value => value: primitives.TStamp)
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
    override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
    override def clusterCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.clusterCreateTime()).map(value => value: primitives.TStamp)
    override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
    override def percentProgressValue: scala.Option[primitives.Integer] = scala.Option(impl.percentProgress()).map(value => value: primitives.Integer)
    override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def dbClusterSnapshotArnValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotArn()).map(value => value: String)
    override def sourceDBClusterSnapshotArnValue: scala.Option[String] = scala.Option(impl.sourceDBClusterSnapshotArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshot): ReadOnly = new Wrapper(impl)
}