package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterSnapshotAttribute(attributeName: scala.Option[String] = None, attributeValues: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute = {
    import DBClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute.builder().optionallyWith(attributeName.map(value => value: java.lang.String))(_.attributeName).optionallyWith(attributeValues.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.attributeValues).build()
  }
  def asReadOnly: DBClusterSnapshotAttribute.ReadOnly = DBClusterSnapshotAttribute.wrap(buildAwsValue())
}
object DBClusterSnapshotAttribute {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterSnapshotAttribute = DBClusterSnapshotAttribute(attributeNameValue.map(value => value), attributeValuesValue.map(value => value))
    def attributeNameValue: scala.Option[String]
    def attributeValuesValue: scala.Option[List[String]]
    def attributeName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeName", attributeNameValue)
    def attributeValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeValues", attributeValuesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute) extends DBClusterSnapshotAttribute.ReadOnly {
    override def attributeNameValue: scala.Option[String] = scala.Option(impl.attributeName()).map(value => value: String)
    override def attributeValuesValue: scala.Option[List[String]] = scala.Option(impl.attributeValues()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttribute): ReadOnly = new Wrapper(impl)
}