package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBClusterSnapshotAttributesResult(dbClusterSnapshotIdentifier: scala.Option[String] = None, dbClusterSnapshotAttributes: scala.Option[Iterable[DBClusterSnapshotAttribute]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult = {
    import DBClusterSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult.builder().optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(dbClusterSnapshotAttributes.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbClusterSnapshotAttributes).build()
  }
  def asReadOnly: DBClusterSnapshotAttributesResult.ReadOnly = DBClusterSnapshotAttributesResult.wrap(buildAwsValue())
}
object DBClusterSnapshotAttributesResult {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBClusterSnapshotAttributesResult = DBClusterSnapshotAttributesResult(dbClusterSnapshotIdentifierValue.map(value => value), dbClusterSnapshotAttributesValue.map(value => value.map { item => 
      item.editable
    }))
    def dbClusterSnapshotIdentifierValue: scala.Option[String]
    def dbClusterSnapshotAttributesValue: scala.Option[List[DBClusterSnapshotAttribute.ReadOnly]]
    def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
    def dbClusterSnapshotAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterSnapshotAttribute.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotAttributes", dbClusterSnapshotAttributesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult) extends DBClusterSnapshotAttributesResult.ReadOnly {
    override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
    override def dbClusterSnapshotAttributesValue: scala.Option[List[DBClusterSnapshotAttribute.ReadOnly]] = scala.Option(impl.dbClusterSnapshotAttributes()).map(value => value.asScala.map { item => 
      DBClusterSnapshotAttribute.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBClusterSnapshotAttributesResult): ReadOnly = new Wrapper(impl)
}