package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBEngineVersion(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, dbEngineDescription: scala.Option[String] = None, dbEngineVersionDescription: scala.Option[String] = None, validUpgradeTarget: scala.Option[Iterable[UpgradeTarget]] = None, exportableLogTypes: scala.Option[Iterable[String]] = None, supportsLogExportsToCloudwatchLogs: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBEngineVersion = {
    import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBEngineVersion.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(dbEngineDescription.map(value => value: java.lang.String))(_.dbEngineDescription).optionallyWith(dbEngineVersionDescription.map(value => value: java.lang.String))(_.dbEngineVersionDescription).optionallyWith(validUpgradeTarget.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.validUpgradeTarget).optionallyWith(exportableLogTypes.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.exportableLogTypes).optionallyWith(supportsLogExportsToCloudwatchLogs.map(value => value: java.lang.Boolean))(_.supportsLogExportsToCloudwatchLogs).build()
  }
  def asReadOnly: DBEngineVersion.ReadOnly = DBEngineVersion.wrap(buildAwsValue())
}
object DBEngineVersion {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBEngineVersion] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBEngineVersion = DBEngineVersion(engineValue.map(value => value), engineVersionValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), dbEngineDescriptionValue.map(value => value), dbEngineVersionDescriptionValue.map(value => value), validUpgradeTargetValue.map(value => value.map { item => 
      item.editable
    }), exportableLogTypesValue.map(value => value), supportsLogExportsToCloudwatchLogsValue.map(value => value))
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def dbParameterGroupFamilyValue: scala.Option[String]
    def dbEngineDescriptionValue: scala.Option[String]
    def dbEngineVersionDescriptionValue: scala.Option[String]
    def validUpgradeTargetValue: scala.Option[List[UpgradeTarget.ReadOnly]]
    def exportableLogTypesValue: scala.Option[List[String]]
    def supportsLogExportsToCloudwatchLogsValue: scala.Option[Boolean]
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
    def dbEngineDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescriptionValue)
    def dbEngineVersionDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineVersionDescription", dbEngineVersionDescriptionValue)
    def validUpgradeTarget: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[UpgradeTarget.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTargetValue)
    def exportableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypesValue)
    def supportsLogExportsToCloudwatchLogs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportsLogExportsToCloudwatchLogs", supportsLogExportsToCloudwatchLogsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion) extends DBEngineVersion.ReadOnly {
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override def dbEngineDescriptionValue: scala.Option[String] = scala.Option(impl.dbEngineDescription()).map(value => value: String)
    override def dbEngineVersionDescriptionValue: scala.Option[String] = scala.Option(impl.dbEngineVersionDescription()).map(value => value: String)
    override def validUpgradeTargetValue: scala.Option[List[UpgradeTarget.ReadOnly]] = scala.Option(impl.validUpgradeTarget()).map(value => value.asScala.map { item => 
      UpgradeTarget.wrap(item)
    }.toList)
    override def exportableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.exportableLogTypes()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def supportsLogExportsToCloudwatchLogsValue: scala.Option[Boolean] = scala.Option(impl.supportsLogExportsToCloudwatchLogs()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion): ReadOnly = new Wrapper(impl)
}