package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBInstance(dbInstanceIdentifier: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, engine: scala.Option[String] = None, dbInstanceStatus: scala.Option[String] = None, endpoint: scala.Option[Endpoint] = None, instanceCreateTime: scala.Option[primitives.TStamp] = None, preferredBackupWindow: scala.Option[String] = None, backupRetentionPeriod: scala.Option[primitives.Integer] = None, vpcSecurityGroups: scala.Option[Iterable[VpcSecurityGroupMembership]] = None, availabilityZone: scala.Option[String] = None, dbSubnetGroup: scala.Option[DBSubnetGroup] = None, preferredMaintenanceWindow: scala.Option[String] = None, pendingModifiedValues: scala.Option[PendingModifiedValues] = None, latestRestorableTime: scala.Option[primitives.TStamp] = None, engineVersion: scala.Option[String] = None, autoMinorVersionUpgrade: scala.Option[Boolean] = None, publiclyAccessible: scala.Option[Boolean] = None, statusInfos: scala.Option[Iterable[DBInstanceStatusInfo]] = None, dbClusterIdentifier: scala.Option[String] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbiResourceId: scala.Option[String] = None, caCertificateIdentifier: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None, dbInstanceArn: scala.Option[String] = None, enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstance.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(_.dbInstanceStatus).optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint).optionallyWith(instanceCreateTime.map(value => value: java.time.Instant))(_.instanceCreateTime).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(vpcSecurityGroups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.vpcSecurityGroups).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(pendingModifiedValues.map(value => value.buildAwsValue()))(_.pendingModifiedValues).optionallyWith(latestRestorableTime.map(value => value: java.time.Instant))(_.latestRestorableTime).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(statusInfos.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.statusInfos).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(_.dbInstanceArn).optionallyWith(enabledCloudwatchLogsExports.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.enabledCloudwatchLogsExports).build()
  }
  def asReadOnly: DBInstance.ReadOnly = DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBInstance] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBInstance = DBInstance(dbInstanceIdentifierValue.map(value => value), dbInstanceClassValue.map(value => value), engineValue.map(value => value), dbInstanceStatusValue.map(value => value), endpointValue.map(value => value.editable), instanceCreateTimeValue.map(value => value), preferredBackupWindowValue.map(value => value), backupRetentionPeriodValue.map(value => value), vpcSecurityGroupsValue.map(value => value.map { item => 
      item.editable
    }), availabilityZoneValue.map(value => value), dbSubnetGroupValue.map(value => value.editable), preferredMaintenanceWindowValue.map(value => value), pendingModifiedValuesValue.map(value => value.editable), latestRestorableTimeValue.map(value => value), engineVersionValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), publiclyAccessibleValue.map(value => value), statusInfosValue.map(value => value.map { item => 
      item.editable
    }), dbClusterIdentifierValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbiResourceIdValue.map(value => value), caCertificateIdentifierValue.map(value => value), promotionTierValue.map(value => value), dbInstanceArnValue.map(value => value), enabledCloudwatchLogsExportsValue.map(value => value))
    def dbInstanceIdentifierValue: scala.Option[String]
    def dbInstanceClassValue: scala.Option[String]
    def engineValue: scala.Option[String]
    def dbInstanceStatusValue: scala.Option[String]
    def endpointValue: scala.Option[Endpoint.ReadOnly]
    def instanceCreateTimeValue: scala.Option[primitives.TStamp]
    def preferredBackupWindowValue: scala.Option[String]
    def backupRetentionPeriodValue: scala.Option[primitives.Integer]
    def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]]
    def availabilityZoneValue: scala.Option[String]
    def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def pendingModifiedValuesValue: scala.Option[PendingModifiedValues.ReadOnly]
    def latestRestorableTimeValue: scala.Option[primitives.TStamp]
    def engineVersionValue: scala.Option[String]
    def autoMinorVersionUpgradeValue: scala.Option[Boolean]
    def publiclyAccessibleValue: scala.Option[Boolean]
    def statusInfosValue: scala.Option[List[DBInstanceStatusInfo.ReadOnly]]
    def dbClusterIdentifierValue: scala.Option[String]
    def storageEncryptedValue: scala.Option[Boolean]
    def kmsKeyIdValue: scala.Option[String]
    def dbiResourceIdValue: scala.Option[String]
    def caCertificateIdentifierValue: scala.Option[String]
    def promotionTierValue: scala.Option[primitives.IntegerOptional]
    def dbInstanceArnValue: scala.Option[String]
    def enabledCloudwatchLogsExportsValue: scala.Option[List[String]]
    def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
    def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def dbInstanceStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatusValue)
    def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Endpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
    def instanceCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTimeValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
    def vpcSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VpcSecurityGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroupsValue)
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def pendingModifiedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PendingModifiedValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValuesValue)
    def latestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
    def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def statusInfos: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceStatusInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusInfos", statusInfosValue)
    def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
    def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
    def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
    def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
    def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
    def dbInstanceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArnValue)
    def enabledCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabledCloudwatchLogsExports", enabledCloudwatchLogsExportsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBInstance) extends DBInstance.ReadOnly {
    override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def dbInstanceStatusValue: scala.Option[String] = scala.Option(impl.dbInstanceStatus()).map(value => value: String)
    override def endpointValue: scala.Option[Endpoint.ReadOnly] = scala.Option(impl.endpoint()).map(value => Endpoint.wrap(value))
    override def instanceCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.instanceCreateTime()).map(value => value: primitives.TStamp)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def backupRetentionPeriodValue: scala.Option[primitives.Integer] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.Integer)
    override def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]] = scala.Option(impl.vpcSecurityGroups()).map(value => value.asScala.map { item => 
      VpcSecurityGroupMembership.wrap(item)
    }.toList)
    override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
    override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value))
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def pendingModifiedValuesValue: scala.Option[PendingModifiedValues.ReadOnly] = scala.Option(impl.pendingModifiedValues()).map(value => PendingModifiedValues.wrap(value))
    override def latestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.latestRestorableTime()).map(value => value: primitives.TStamp)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def autoMinorVersionUpgradeValue: scala.Option[Boolean] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def statusInfosValue: scala.Option[List[DBInstanceStatusInfo.ReadOnly]] = scala.Option(impl.statusInfos()).map(value => value.asScala.map { item => 
      DBInstanceStatusInfo.wrap(item)
    }.toList)
    override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
    override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
    override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
    override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
    override def dbInstanceArnValue: scala.Option[String] = scala.Option(impl.dbInstanceArn()).map(value => value: String)
    override def enabledCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enabledCloudwatchLogsExports()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBInstance): ReadOnly = new Wrapper(impl)
}