package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBInstanceStatusInfo(statusType: scala.Option[String] = None, normal: scala.Option[Boolean] = None, status: scala.Option[String] = None, message: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo = {
    import DBInstanceStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo.builder().optionallyWith(statusType.map(value => value: java.lang.String))(_.statusType).optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
  }
  def asReadOnly: DBInstanceStatusInfo.ReadOnly = DBInstanceStatusInfo.wrap(buildAwsValue())
}
object DBInstanceStatusInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBInstanceStatusInfo = DBInstanceStatusInfo(statusTypeValue.map(value => value), normalValue.map(value => value), statusValue.map(value => value), messageValue.map(value => value))
    def statusTypeValue: scala.Option[String]
    def normalValue: scala.Option[Boolean]
    def statusValue: scala.Option[String]
    def messageValue: scala.Option[String]
    def statusType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusType", statusTypeValue)
    def normal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("normal", normalValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo) extends DBInstanceStatusInfo.ReadOnly {
    override def statusTypeValue: scala.Option[String] = scala.Option(impl.statusType()).map(value => value: String)
    override def normalValue: scala.Option[Boolean] = scala.Option(impl.normal()).map(value => value: Boolean)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBInstanceStatusInfo): ReadOnly = new Wrapper(impl)
}