package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DBSubnetGroup(dbSubnetGroupName: scala.Option[String] = None, dbSubnetGroupDescription: scala.Option[String] = None, vpcId: scala.Option[String] = None, subnetGroupStatus: scala.Option[String] = None, subnets: scala.Option[Iterable[Subnet]] = None, dbSubnetGroupArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DBSubnetGroup = {
    import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBSubnetGroup.builder().optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(dbSubnetGroupDescription.map(value => value: java.lang.String))(_.dbSubnetGroupDescription).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(_.subnetGroupStatus).optionallyWith(subnets.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.subnets).optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(_.dbSubnetGroupArn).build()
  }
  def asReadOnly: DBSubnetGroup.ReadOnly = DBSubnetGroup.wrap(buildAwsValue())
}
object DBSubnetGroup {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DBSubnetGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DBSubnetGroup = DBSubnetGroup(dbSubnetGroupNameValue.map(value => value), dbSubnetGroupDescriptionValue.map(value => value), vpcIdValue.map(value => value), subnetGroupStatusValue.map(value => value), subnetsValue.map(value => value.map { item => 
      item.editable
    }), dbSubnetGroupArnValue.map(value => value))
    def dbSubnetGroupNameValue: scala.Option[String]
    def dbSubnetGroupDescriptionValue: scala.Option[String]
    def vpcIdValue: scala.Option[String]
    def subnetGroupStatusValue: scala.Option[String]
    def subnetsValue: scala.Option[List[Subnet.ReadOnly]]
    def dbSubnetGroupArnValue: scala.Option[String]
    def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
    def dbSubnetGroupDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescriptionValue)
    def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
    def subnetGroupStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatusValue)
    def subnets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Subnet.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnets", subnetsValue)
    def dbSubnetGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup) extends DBSubnetGroup.ReadOnly {
    override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override def dbSubnetGroupDescriptionValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
    override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
    override def subnetGroupStatusValue: scala.Option[String] = scala.Option(impl.subnetGroupStatus()).map(value => value: String)
    override def subnetsValue: scala.Option[List[Subnet.ReadOnly]] = scala.Option(impl.subnets()).map(value => value.asScala.map { item => 
      Subnet.wrap(item)
    }.toList)
    override def dbSubnetGroupArnValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupArn()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DBSubnetGroup): ReadOnly = new Wrapper(impl)
}