package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupName: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest = {
    import DeleteDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).build()
  }
  def asReadOnly: DeleteDbClusterParameterGroupRequest.ReadOnly = DeleteDbClusterParameterGroupRequest.wrap(buildAwsValue())
}
object DeleteDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDbClusterParameterGroupRequest = DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue)
    def dbClusterParameterGroupNameValue: String
    def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest) extends DeleteDbClusterParameterGroupRequest.ReadOnly { override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
}