package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDbClusterRequest(dbClusterIdentifier: String, skipFinalSnapshot: scala.Option[Boolean] = None, finalDBSnapshotIdentifier: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest = {
    import DeleteDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(_.skipFinalSnapshot).optionallyWith(finalDBSnapshotIdentifier.map(value => value: java.lang.String))(_.finalDBSnapshotIdentifier).build()
  }
  def asReadOnly: DeleteDbClusterRequest.ReadOnly = DeleteDbClusterRequest.wrap(buildAwsValue())
}
object DeleteDbClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDbClusterRequest = DeleteDbClusterRequest(dbClusterIdentifierValue, skipFinalSnapshotValue.map(value => value), finalDBSnapshotIdentifierValue.map(value => value))
    def dbClusterIdentifierValue: String
    def skipFinalSnapshotValue: scala.Option[Boolean]
    def finalDBSnapshotIdentifierValue: scala.Option[String]
    def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
    def skipFinalSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshotValue)
    def finalDBSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest) extends DeleteDbClusterRequest.ReadOnly {
    override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
    override def skipFinalSnapshotValue: scala.Option[Boolean] = scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
    override def finalDBSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest): ReadOnly = new Wrapper(impl)
}