package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDbClusterSnapshotRequest(dbClusterSnapshotIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest = {
    import DeleteDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).build()
  }
  def asReadOnly: DeleteDbClusterSnapshotRequest.ReadOnly = DeleteDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object DeleteDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDbClusterSnapshotRequest = DeleteDbClusterSnapshotRequest(dbClusterSnapshotIdentifierValue)
    def dbClusterSnapshotIdentifierValue: String
    def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest) extends DeleteDbClusterSnapshotRequest.ReadOnly { override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
}