package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDbInstanceRequest(dbInstanceIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest = {
    import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).build()
  }
  def asReadOnly: DeleteDbInstanceRequest.ReadOnly = DeleteDbInstanceRequest.wrap(buildAwsValue())
}
object DeleteDbInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDbInstanceRequest = DeleteDbInstanceRequest(dbInstanceIdentifierValue)
    def dbInstanceIdentifierValue: String
    def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest) extends DeleteDbInstanceRequest.ReadOnly { override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest): ReadOnly = new Wrapper(impl)
}