package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDbSubnetGroupRequest(dbSubnetGroupName: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest = {
    import DeleteDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).build()
  }
  def asReadOnly: DeleteDbSubnetGroupRequest.ReadOnly = DeleteDbSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDbSubnetGroupRequest = DeleteDbSubnetGroupRequest(dbSubnetGroupNameValue)
    def dbSubnetGroupNameValue: String
    def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest) extends DeleteDbSubnetGroupRequest.ReadOnly { override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
}