package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteEventSubscriptionRequest(subscriptionName: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest = {
    import DeleteEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).build()
  }
  def asReadOnly: DeleteEventSubscriptionRequest.ReadOnly = DeleteEventSubscriptionRequest.wrap(buildAwsValue())
}
object DeleteEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteEventSubscriptionRequest = DeleteEventSubscriptionRequest(subscriptionNameValue)
    def subscriptionNameValue: String
    def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest) extends DeleteEventSubscriptionRequest.ReadOnly { override def subscriptionNameValue: String = impl.subscriptionName(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
}