package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteGlobalClusterRequest(globalClusterIdentifier: primitives.GlobalClusterIdentifier) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest = {
    import DeleteGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).build()
  }
  def asReadOnly: DeleteGlobalClusterRequest.ReadOnly = DeleteGlobalClusterRequest.wrap(buildAwsValue())
}
object DeleteGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteGlobalClusterRequest = DeleteGlobalClusterRequest(globalClusterIdentifierValue)
    def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier
    def globalClusterIdentifier: ZIO[Any, Nothing, primitives.GlobalClusterIdentifier] = ZIO.succeed(globalClusterIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest) extends DeleteGlobalClusterRequest.ReadOnly { override def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier = impl.globalClusterIdentifier(): primitives.GlobalClusterIdentifier }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest): ReadOnly = new Wrapper(impl)
}