package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteGlobalClusterResponse(globalCluster: scala.Option[GlobalCluster] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse = {
    import DeleteGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse.builder().optionallyWith(globalCluster.map(value => value.buildAwsValue()))(_.globalCluster).build()
  }
  def asReadOnly: DeleteGlobalClusterResponse.ReadOnly = DeleteGlobalClusterResponse.wrap(buildAwsValue())
}
object DeleteGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteGlobalClusterResponse = DeleteGlobalClusterResponse(globalClusterValue.map(value => value.editable))
    def globalClusterValue: scala.Option[GlobalCluster.ReadOnly]
    def globalCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GlobalCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalCluster", globalClusterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse) extends DeleteGlobalClusterResponse.ReadOnly { override def globalClusterValue: scala.Option[GlobalCluster.ReadOnly] = scala.Option(impl.globalCluster()).map(value => GlobalCluster.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse): ReadOnly = new Wrapper(impl)
}