package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeCertificatesResponse(certificates: scala.Option[Iterable[Certificate]] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse = {
    import DescribeCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse.builder().optionallyWith(certificates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.certificates).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeCertificatesResponse.ReadOnly = DescribeCertificatesResponse.wrap(buildAwsValue())
}
object DescribeCertificatesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeCertificatesResponse = DescribeCertificatesResponse(certificatesValue.map(value => value.map { item => 
      item.editable
    }), markerValue.map(value => value))
    def certificatesValue: scala.Option[List[Certificate.ReadOnly]]
    def markerValue: scala.Option[String]
    def certificates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Certificate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificates", certificatesValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse) extends DescribeCertificatesResponse.ReadOnly {
    override def certificatesValue: scala.Option[List[Certificate.ReadOnly]] = scala.Option(impl.certificates()).map(value => value.asScala.map { item => 
      Certificate.wrap(item)
    }.toList)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse): ReadOnly = new Wrapper(impl)
}