package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClusterParameterGroupsResponse(marker: scala.Option[String] = None, dbClusterParameterGroups: scala.Option[Iterable[DBClusterParameterGroup]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse = {
    import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterParameterGroups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbClusterParameterGroups).build()
  }
  def asReadOnly: DescribeDbClusterParameterGroupsResponse.ReadOnly = DescribeDbClusterParameterGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClusterParameterGroupsResponse = DescribeDbClusterParameterGroupsResponse(markerValue.map(value => value), dbClusterParameterGroupsValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbClusterParameterGroupsValue: scala.Option[List[DBClusterParameterGroup.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbClusterParameterGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterParameterGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroups", dbClusterParameterGroupsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse) extends DescribeDbClusterParameterGroupsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbClusterParameterGroupsValue: scala.Option[List[DBClusterParameterGroup.ReadOnly]] = scala.Option(impl.dbClusterParameterGroups()).map(value => value.asScala.map { item => 
      DBClusterParameterGroup.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse): ReadOnly = new Wrapper(impl)
}