package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClusterParametersResponse(parameters: scala.Option[Iterable[Parameter]] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse = {
    import DescribeDbClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse.builder().optionallyWith(parameters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parameters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeDbClusterParametersResponse.ReadOnly = DescribeDbClusterParametersResponse.wrap(buildAwsValue())
}
object DescribeDbClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClusterParametersResponse = DescribeDbClusterParametersResponse(parametersValue.map(value => value.map { item => 
      item.editable
    }), markerValue.map(value => value))
    def parametersValue: scala.Option[List[Parameter.ReadOnly]]
    def markerValue: scala.Option[String]
    def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse) extends DescribeDbClusterParametersResponse.ReadOnly {
    override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
      Parameter.wrap(item)
    }.toList)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse): ReadOnly = new Wrapper(impl)
}