package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClusterSnapshotAttributesRequest(dbClusterSnapshotIdentifier: String) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest = {
    import DescribeDbClusterSnapshotAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).build()
  }
  def asReadOnly: DescribeDbClusterSnapshotAttributesRequest.ReadOnly = DescribeDbClusterSnapshotAttributesRequest.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotAttributesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClusterSnapshotAttributesRequest = DescribeDbClusterSnapshotAttributesRequest(dbClusterSnapshotIdentifierValue)
    def dbClusterSnapshotIdentifierValue: String
    def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest) extends DescribeDbClusterSnapshotAttributesRequest.ReadOnly { override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest): ReadOnly = new Wrapper(impl)
}