package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClusterSnapshotsRequest(dbClusterIdentifier: scala.Option[String] = None, dbClusterSnapshotIdentifier: scala.Option[String] = None, snapshotType: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, includeShared: scala.Option[Boolean] = None, includePublic: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest = {
    import DescribeDbClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(includeShared.map(value => value: java.lang.Boolean))(_.includeShared).optionallyWith(includePublic.map(value => value: java.lang.Boolean))(_.includePublic).build()
  }
  def asReadOnly: DescribeDbClusterSnapshotsRequest.ReadOnly = DescribeDbClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest(dbClusterIdentifierValue.map(value => value), dbClusterSnapshotIdentifierValue.map(value => value), snapshotTypeValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value), includeSharedValue.map(value => value), includePublicValue.map(value => value))
    def dbClusterIdentifierValue: scala.Option[String]
    def dbClusterSnapshotIdentifierValue: scala.Option[String]
    def snapshotTypeValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def includeSharedValue: scala.Option[Boolean]
    def includePublicValue: scala.Option[Boolean]
    def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
    def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
    def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def includeShared: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeShared", includeSharedValue)
    def includePublic: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includePublic", includePublicValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest) extends DescribeDbClusterSnapshotsRequest.ReadOnly {
    override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
    override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
    override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def includeSharedValue: scala.Option[Boolean] = scala.Option(impl.includeShared()).map(value => value: Boolean)
    override def includePublicValue: scala.Option[Boolean] = scala.Option(impl.includePublic()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest): ReadOnly = new Wrapper(impl)
}