package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClusterSnapshotsResponse(marker: scala.Option[String] = None, dbClusterSnapshots: scala.Option[Iterable[DBClusterSnapshot]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse = {
    import DescribeDbClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterSnapshots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbClusterSnapshots).build()
  }
  def asReadOnly: DescribeDbClusterSnapshotsResponse.ReadOnly = DescribeDbClusterSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClusterSnapshotsResponse = DescribeDbClusterSnapshotsResponse(markerValue.map(value => value), dbClusterSnapshotsValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbClusterSnapshotsValue: scala.Option[List[DBClusterSnapshot.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbClusterSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshots", dbClusterSnapshotsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse) extends DescribeDbClusterSnapshotsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbClusterSnapshotsValue: scala.Option[List[DBClusterSnapshot.ReadOnly]] = scala.Option(impl.dbClusterSnapshots()).map(value => value.asScala.map { item => 
      DBClusterSnapshot.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse): ReadOnly = new Wrapper(impl)
}