package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbClustersResponse(marker: scala.Option[String] = None, dbClusters: scala.Option[Iterable[DBCluster]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse = {
    import DescribeDbClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbClusters).build()
  }
  def asReadOnly: DescribeDbClustersResponse.ReadOnly = DescribeDbClustersResponse.wrap(buildAwsValue())
}
object DescribeDbClustersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbClustersResponse = DescribeDbClustersResponse(markerValue.map(value => value), dbClustersValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbClustersValue: scala.Option[List[DBCluster.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbClusters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBCluster.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusters", dbClustersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse) extends DescribeDbClustersResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbClustersValue: scala.Option[List[DBCluster.ReadOnly]] = scala.Option(impl.dbClusters()).map(value => value.asScala.map { item => 
      DBCluster.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse): ReadOnly = new Wrapper(impl)
}