package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbEngineVersionsRequest(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, defaultOnly: scala.Option[Boolean] = None, listSupportedCharacterSets: scala.Option[primitives.BooleanOptional] = None, listSupportedTimezones: scala.Option[primitives.BooleanOptional] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest = {
    import DescribeDbEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(_.defaultOnly).optionallyWith(listSupportedCharacterSets.map(value => value: java.lang.Boolean))(_.listSupportedCharacterSets).optionallyWith(listSupportedTimezones.map(value => value: java.lang.Boolean))(_.listSupportedTimezones).build()
  }
  def asReadOnly: DescribeDbEngineVersionsRequest.ReadOnly = DescribeDbEngineVersionsRequest.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest(engineValue.map(value => value), engineVersionValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value), defaultOnlyValue.map(value => value), listSupportedCharacterSetsValue.map(value => value), listSupportedTimezonesValue.map(value => value))
    def engineValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def dbParameterGroupFamilyValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def defaultOnlyValue: scala.Option[Boolean]
    def listSupportedCharacterSetsValue: scala.Option[primitives.BooleanOptional]
    def listSupportedTimezonesValue: scala.Option[primitives.BooleanOptional]
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def defaultOnly: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultOnly", defaultOnlyValue)
    def listSupportedCharacterSets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("listSupportedCharacterSets", listSupportedCharacterSetsValue)
    def listSupportedTimezones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("listSupportedTimezones", listSupportedTimezonesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest) extends DescribeDbEngineVersionsRequest.ReadOnly {
    override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def defaultOnlyValue: scala.Option[Boolean] = scala.Option(impl.defaultOnly()).map(value => value: Boolean)
    override def listSupportedCharacterSetsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.listSupportedCharacterSets()).map(value => value: primitives.BooleanOptional)
    override def listSupportedTimezonesValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.listSupportedTimezones()).map(value => value: primitives.BooleanOptional)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest): ReadOnly = new Wrapper(impl)
}