package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbEngineVersionsResponse(marker: scala.Option[String] = None, dbEngineVersions: scala.Option[Iterable[DBEngineVersion]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse = {
    import DescribeDbEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbEngineVersions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbEngineVersions).build()
  }
  def asReadOnly: DescribeDbEngineVersionsResponse.ReadOnly = DescribeDbEngineVersionsResponse.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbEngineVersionsResponse = DescribeDbEngineVersionsResponse(markerValue.map(value => value), dbEngineVersionsValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbEngineVersionsValue: scala.Option[List[DBEngineVersion.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbEngineVersions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBEngineVersion.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineVersions", dbEngineVersionsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse) extends DescribeDbEngineVersionsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbEngineVersionsValue: scala.Option[List[DBEngineVersion.ReadOnly]] = scala.Option(impl.dbEngineVersions()).map(value => value.asScala.map { item => 
      DBEngineVersion.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse): ReadOnly = new Wrapper(impl)
}