package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbInstancesRequest(dbInstanceIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest = {
    import DescribeDbInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeDbInstancesRequest.ReadOnly = DescribeDbInstancesRequest.wrap(buildAwsValue())
}
object DescribeDbInstancesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbInstancesRequest = DescribeDbInstancesRequest(dbInstanceIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value))
    def dbInstanceIdentifierValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest) extends DescribeDbInstancesRequest.ReadOnly {
    override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest): ReadOnly = new Wrapper(impl)
}