package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbInstancesResponse(marker: scala.Option[String] = None, dbInstances: scala.Option[Iterable[DBInstance]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse = {
    import DescribeDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbInstances.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbInstances).build()
  }
  def asReadOnly: DescribeDbInstancesResponse.ReadOnly = DescribeDbInstancesResponse.wrap(buildAwsValue())
}
object DescribeDbInstancesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbInstancesResponse = DescribeDbInstancesResponse(markerValue.map(value => value), dbInstancesValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbInstancesValue: scala.Option[List[DBInstance.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbInstances: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstance.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstances", dbInstancesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse) extends DescribeDbInstancesResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbInstancesValue: scala.Option[List[DBInstance.ReadOnly]] = scala.Option(impl.dbInstances()).map(value => value.asScala.map { item => 
      DBInstance.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse): ReadOnly = new Wrapper(impl)
}