package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeDbSubnetGroupsResponse(marker: scala.Option[String] = None, dbSubnetGroups: scala.Option[Iterable[DBSubnetGroup]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse = {
    import DescribeDbSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbSubnetGroups.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.dbSubnetGroups).build()
  }
  def asReadOnly: DescribeDbSubnetGroupsResponse.ReadOnly = DescribeDbSubnetGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeDbSubnetGroupsResponse = DescribeDbSubnetGroupsResponse(markerValue.map(value => value), dbSubnetGroupsValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def dbSubnetGroupsValue: scala.Option[List[DBSubnetGroup.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def dbSubnetGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSubnetGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroups", dbSubnetGroupsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse) extends DescribeDbSubnetGroupsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def dbSubnetGroupsValue: scala.Option[List[DBSubnetGroup.ReadOnly]] = scala.Option(impl.dbSubnetGroups()).map(value => value.asScala.map { item => 
      DBSubnetGroup.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse): ReadOnly = new Wrapper(impl)
}