package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEngineDefaultClusterParametersRequest(dbParameterGroupFamily: String, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest = {
    import DescribeEngineDefaultClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest.builder().dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeEngineDefaultClusterParametersRequest.ReadOnly = DescribeEngineDefaultClusterParametersRequest.wrap(buildAwsValue())
}
object DescribeEngineDefaultClusterParametersRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEngineDefaultClusterParametersRequest = DescribeEngineDefaultClusterParametersRequest(dbParameterGroupFamilyValue, filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value))
    def dbParameterGroupFamilyValue: String
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest) extends DescribeEngineDefaultClusterParametersRequest.ReadOnly {
    override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest): ReadOnly = new Wrapper(impl)
}