package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEngineDefaultClusterParametersResponse(engineDefaults: scala.Option[EngineDefaults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse = {
    import DescribeEngineDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse.builder().optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(_.engineDefaults).build()
  }
  def asReadOnly: DescribeEngineDefaultClusterParametersResponse.ReadOnly = DescribeEngineDefaultClusterParametersResponse.wrap(buildAwsValue())
}
object DescribeEngineDefaultClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEngineDefaultClusterParametersResponse = DescribeEngineDefaultClusterParametersResponse(engineDefaultsValue.map(value => value.editable))
    def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly]
    def engineDefaults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EngineDefaults.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineDefaults", engineDefaultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse) extends DescribeEngineDefaultClusterParametersResponse.ReadOnly { override def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly] = scala.Option(impl.engineDefaults()).map(value => EngineDefaults.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse): ReadOnly = new Wrapper(impl)
}