package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEventCategoriesRequest(sourceType: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest.builder().optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).build()
  }
  def asReadOnly: DescribeEventCategoriesRequest.ReadOnly = DescribeEventCategoriesRequest.wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest(sourceTypeValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }))
    def sourceTypeValue: scala.Option[String]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest) extends DescribeEventCategoriesRequest.ReadOnly {
    override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest): ReadOnly = new Wrapper(impl)
}