package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEventSubscriptionsResponse(marker: scala.Option[String] = None, eventSubscriptionsList: scala.Option[Iterable[EventSubscription]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsResponse = {
    import DescribeEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(eventSubscriptionsList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.eventSubscriptionsList).build()
  }
  def asReadOnly: DescribeEventSubscriptionsResponse.ReadOnly = DescribeEventSubscriptionsResponse.wrap(buildAwsValue())
}
object DescribeEventSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEventSubscriptionsResponse = DescribeEventSubscriptionsResponse(markerValue.map(value => value), eventSubscriptionsListValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def eventSubscriptionsListValue: scala.Option[List[EventSubscription.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def eventSubscriptionsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EventSubscription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscriptionsList", eventSubscriptionsListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsResponse) extends DescribeEventSubscriptionsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def eventSubscriptionsListValue: scala.Option[List[EventSubscription.ReadOnly]] = scala.Option(impl.eventSubscriptionsList()).map(value => value.asScala.map { item => 
      EventSubscription.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsResponse): ReadOnly = new Wrapper(impl)
}