package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEventsRequest(sourceIdentifier: scala.Option[String] = None, sourceType: scala.Option[SourceType] = None, startTime: scala.Option[primitives.TStamp] = None, endTime: scala.Option[primitives.TStamp] = None, duration: scala.Option[primitives.IntegerOptional] = None, eventCategories: scala.Option[Iterable[String]] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventsRequest.builder().optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(_.sourceIdentifier).optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType).optionallyWith(startTime.map(value => value: java.time.Instant))(_.startTime).optionallyWith(endTime.map(value => value: java.time.Instant))(_.endTime).optionallyWith(duration.map(value => value: java.lang.Integer))(_.duration).optionallyWith(eventCategories.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.eventCategories).optionallyWith(filters.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
  }
  def asReadOnly: DescribeEventsRequest.ReadOnly = DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEventsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEventsRequest = DescribeEventsRequest(sourceIdentifierValue.map(value => value), sourceTypeValue.map(value => value), startTimeValue.map(value => value), endTimeValue.map(value => value), durationValue.map(value => value), eventCategoriesValue.map(value => value), filtersValue.map(value => value.map { item => 
      item.editable
    }), maxRecordsValue.map(value => value), markerValue.map(value => value))
    def sourceIdentifierValue: scala.Option[String]
    def sourceTypeValue: scala.Option[SourceType]
    def startTimeValue: scala.Option[primitives.TStamp]
    def endTimeValue: scala.Option[primitives.TStamp]
    def durationValue: scala.Option[primitives.IntegerOptional]
    def eventCategoriesValue: scala.Option[List[String]]
    def filtersValue: scala.Option[List[Filter.ReadOnly]]
    def maxRecordsValue: scala.Option[primitives.IntegerOptional]
    def markerValue: scala.Option[String]
    def sourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifierValue)
    def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
    def startTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endTime", endTimeValue)
    def duration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("duration", durationValue)
    def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
    def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEventsRequest) extends DescribeEventsRequest.ReadOnly {
    override def sourceIdentifierValue: scala.Option[String] = scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override def sourceTypeValue: scala.Option[SourceType] = scala.Option(impl.sourceType()).map(value => SourceType.wrap(value))
    override def startTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.startTime()).map(value => value: primitives.TStamp)
    override def endTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.endTime()).map(value => value: primitives.TStamp)
    override def durationValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.duration()).map(value => value: primitives.IntegerOptional)
    override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
      Filter.wrap(item)
    }.toList)
    override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEventsRequest): ReadOnly = new Wrapper(impl)
}