package io.github.vigoo.zioaws.docdb.model
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEventsResponse(marker: scala.Option[String] = None, events: scala.Option[Iterable[Event]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeEventsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(events.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.events).build()
  }
  def asReadOnly: DescribeEventsResponse.ReadOnly = DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.docdb.model.DescribeEventsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEventsResponse = DescribeEventsResponse(markerValue.map(value => value), eventsValue.map(value => value.map { item => 
      item.editable
    }))
    def markerValue: scala.Option[String]
    def eventsValue: scala.Option[List[Event.ReadOnly]]
    def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    def events: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Event.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("events", eventsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.docdb.model.DescribeEventsResponse) extends DescribeEventsResponse.ReadOnly {
    override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    override def eventsValue: scala.Option[List[Event.ReadOnly]] = scala.Option(impl.events()).map(value => value.asScala.map { item => 
      Event.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.docdb.model.DescribeEventsResponse): ReadOnly = new Wrapper(impl)
}